//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.4
import QtQuick.Controls        1.3
import QtQuick.Controls.Styles 1.3

import wesual.Controls 1.0


SpinBox {
    id : spinBox

    implicitWidth  : 60
    implicitHeight : 26

    // accessors for mouse areas in spin box
    property Item up   : null
    property Item down : null

    Component.onCompleted: {
        for (var i = 0; i < children.length; ++i) {
            if (children[i].objectName === "mouseUp")
                up = children[i];
            else if (children[i].objectName === "mouseDown")
                down = children[i];
        }
    }

    style : SpinBoxStyle {
        id : style

        selectionColor      : UI.color(UI.TextSelection)
        selectedTextColor   : UI.color(UI.SelectedTextColor)
        horizontalAlignment : Qt.AlignLeft

        font {
            pixelSize : 14
            family    : UI.fontFamily(UI.PrimaryFont)
            weight    : UI.fontWeight(UI.PrimaryFont)
        }

        incrementControl : Item {
            implicitWidth  : 20
            implicitHeight : 13
            Component.onCompleted : {
                var properties = {
                    "mouseArea" : Qt.binding(function() {
                        return control.up;
                    })
                }
                incrementDecrementComponent.createObject(parent,
                                                         properties);
            }
        }

        decrementControl : Item {
            implicitWidth  : 20
            implicitHeight : 13
            Component.onCompleted : {
                var properties = {
                    "increment" : false,
                    "mouseArea" : Qt.binding(function() {
                        return control.down;
                    })
                }
                incrementDecrementComponent.createObject(parent,
                                                         properties);
            }
        }

        background : Rectangle {
            implicitWidth  : control.width
            implicitHeight : control.height
            color : "transparent"
            border.width : 1
            border.color : {
                if (control.activeFocus)
                    return UI.color(UI.ControlBorderPress);
                if (control.hovered)
                    return UI.color(UI.ControlBorderHover);

                return UI.color(UI.PrimaryControlBorder);
            }
        }
    }

    // Component for increment/decrement button visualization
    Component {
        id : incrementDecrementComponent

        Rectangle {
            id : component

            property bool increment : true
            property Item mouseArea

            implicitWidth  : 20
            implicitHeight : mouseArea.height
            color : "transparent"

            ColorizedImage {
                id : arrow

                width  : 7
                height : 4
                y : increment ? component.height - height - 3 : 3
                rotation : increment ? 180 : 0
                anchors.horizontalCenter : parent.horizontalCenter
                source : "qrc:/controls/icons/stepper-arrows.png"
                color  : UI.color(UI.DropdownIndicatorIcon)
            }
            states : [
                State {
                    name : "pressed"
                    when : mouseArea.pressed
                    PropertyChanges {
                        target : component
                        color  : UI.color(UI.PrimaryPress)
                    }
                    PropertyChanges {
                        target : arrow
                        color  : UI.color(UI.PrimaryBase)
                    }
                },
                State {
                    name : "hovered"
                    when : mouseArea.containsMouse
                    PropertyChanges {
                        target : component
                        color  : UI.color(UI.PrimaryHover)
                    }
                }
            ]
        }
    }
}
